#ifndef _HANDSHAKE_CPP
#define _HANDSHAKE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "HandShake.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsValidCompanyAccount(CSockSrvr *pSockSrvr, int iClient);
int IsValidClientVersion(CSockSrvr *pSockSrvr, int iClient, char *UpdateHTTPURL);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void BinPrint(const char *sData, int iLen)
{
	int iRPos = 0;
	while(iRPos < iLen)
	{
		printf("%X\n", sData[iRPos]);
		iRPos++;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int PerformHandShake(int iClient, char *sRecvBuf, int iRecvBufSz)

	Performs a hand shake. Also know as Client/Server Authentication.

	Possible return Values:
		AUTH_FAILED   //The authentication process failed.
		AUTH_SUCCESS  //The authentication process was a success.
		AUTH_OK       //The authentication process is still in process, all is well.
		AUTH_ERROR    //The authentication process failed due to an error.
*/
int PerformHandShake(CSockSrvr *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[IDEAL_RECV_SIZE + 1];
    char sSendBuf[IDEAL_SEND_SIZE + 1];
	char sTemp[IDEAL_SEND_SIZE];

	int iSendBufSz = 0;
	int iCmdDataSz = 0;
	int iCmdFlagLength = 0;

    if((iCmdFlagLength = CmdCmp(sCmdBuf, "::AuthString->")))
    {
		if(CCI[iClient].iAuthStep != 0)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		char sNewAuthKey_Crypt[MAX_KEY_LENGTH];
		char sNewAuthKey[MAX_KEY_LENGTH];

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		WriteLog(pSockSrvr->icClientID[iClient], "Initializing Cryptography Set...");
		memset(&CCI[iClient].cNASCCL, 0, sizeof(CCI[iClient].cNASCCL));
		if(CCI[iClient].cNASCCL.InitializeCryptographySet(gsAuthKey, strlen(gsAuthKey), CRYPTFLAGS))
		{
			CCI[iClient].bIsEncryptionInit = true;
		}
		else{
			CCI[iClient].bIsEncryptionInit = false;
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to failure to initialize cryptography.");
			return AUTH_ERROR;
		}

		CCI[iClient].cNASCCL.Decode(sCmdData, sTemp, iCmdDataSz);
		sTemp[iCmdDataSz] = '\0';

		WriteLog(pSockSrvr->icClientID[iClient], "Received authentication string.");

		if(strcmp(sTemp, gsAuthString) != 0)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication String.");
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
			return AUTH_FAILED;
		}
		
		WriteLog(pSockSrvr->icClientID[iClient], "Validation of Authentication String verified.");
		
		if(!GenerateKey(giKeyGenLength, (GetTickCount()+iClient), GKUPPER_AZ|GKNUMBERS|GKNONREPETITION, sNewAuthKey))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "PerformHandShake failed to generate a key.");
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
			return AUTH_ERROR;
		}

		CCI[iClient].cNASCCL.Encode(sNewAuthKey, sNewAuthKey_Crypt, giKeyGenLength);
		CCI[iClient].cNASCCL.UninitializeCryptographySet();
		memset(&CCI[iClient].cNASCCL, 0, sizeof(CCI[iClient].cNASCCL));

		if(!CCI[iClient].cNASCCL.InitializeCryptographySet(sNewAuthKey, giKeyGenLength, CRYPTFLAGS))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to Initialize the cryptography set.");
		}

		iSendBufSz = AppendDataToCmd("::NewAuthKey->", sNewAuthKey_Crypt, giKeyGenLength, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);

		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::NewKeyAuth->")))
    {
		if(CCI[iClient].iAuthStep != 1)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		WriteLog(pSockSrvr->icClientID[iClient], "Received new key Authentication string.");

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		CCI[iClient].cNASCCL.Decode(sCmdData, sTemp, iCmdDataSz);
		sTemp[iCmdDataSz] = '\0';

		if(strcmp(sTemp, gsAuthString) != 0)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid key.");
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
			return AUTH_FAILED;
		}
		
		WriteLog(pSockSrvr->icClientID[iClient], "Encryption key exchange complete.");

		pSockSrvr->SetNextSendData(iClient, "::RequestVersion");
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Version->")))
    {
		if(CCI[iClient].iAuthStep != 2)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI[iClient].cNASCCL.Decode(sCmdData, sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';

		strcpy(CCI[iClient].sClientVersion, sCmdData); // Save the client version.

		sprintf(sTemp, "Client Version: %s", sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sTemp);

		if(CCI[iClient].cIndexSQL.Connect(gsSQLIndexDriver, gsSQLIndexServer, gsSQLIndexUserID, gsSQLIndexPassword, gsSQLIndexDatabase))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Successfully connected to the Index database.");
			CCI[iClient].bWPIndexConnected = true;
		}
		else{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to connect to the Index database.");
			return AUTH_ERROR;
		}

        char sUpdateHTTPURL[1024 + 1];

        int iCVResult = IsValidClientVersion(pSockSrvr, iClient, sUpdateHTTPURL);
        if(iCVResult == CLIENTVER_CURRENT){
			WriteLog(pSockSrvr->icClientID[iClient], "Client software is up-to-date.");
			pSockSrvr->SetNextSendData(iClient, "::RequestCompanyName");
            return AUTH_OK;
        }
        else if(iCVResult == CLIENTVER_SUPPORTED){
			WriteLog(pSockSrvr->icClientID[iClient], "Client software is outdated but still supported. Update soon!");
			pSockSrvr->SetNextSendData(iClient, "::RequestCompanyName");
            return AUTH_OK;
        }
        else if(iCVResult == CLIENTVER_OUTDATED){
			WriteLog(pSockSrvr->icClientID[iClient], "Client software is outdated. Update now!");
            return AUTH_ERROR;
        }
        else if(iCVResult == CLIENTVER_AUTOUPDATE){
			WriteLog(pSockSrvr->icClientID[iClient], "Performing client autoupdate.");

            sprintf(sTemp, "::AutoUpdate->%s", sUpdateHTTPURL);
            pSockSrvr->SetNextSendData(iClient, sTemp);
            return AUTH_OK;
        }
        else{
			WriteLog(pSockSrvr->icClientID[iClient], "Error verifing client version.");
            return AUTH_ERROR;
        }

		pSockSrvr->SetNextSendData(iClient, "::RequestCompanyName");
		return AUTH_ERROR;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::CompanyName->")))
    {
		if(CCI[iClient].iAuthStep != 3)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI[iClient].cNASCCL.Decode(sCmdData, sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';

		strcpy(CCI[iClient].sCompanyName, sCmdData); // Svae the company name;
	
		sprintf(sTemp, "Company Name: %s", sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sTemp);

		pSockSrvr->SetNextSendData(iClient, "::RequestPassword");
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::Password->")))
    {
		if(CCI[iClient].iAuthStep != 4)
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Authentication failed due to invalid Authentication step.");
			return AUTH_ERROR;
		}
		else CCI[iClient].iAuthStep++;

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI[iClient].cNASCCL.Decode(sCmdData, sCmdData, iCmdDataSz);
		sCmdData[iCmdDataSz] = '\0';

		strcpy(CCI[iClient].sPassword, sCmdData); // Svae the password;

		sprintf(sTemp, "Password: %s", sCmdData);
		WriteLog(pSockSrvr->icClientID[iClient], sTemp);

        if(!IsValidCompanyAccount(pSockSrvr, iClient))
        {
			WriteLog(pSockSrvr->icClientID[iClient], "Invalid company account.");
			pSockSrvr->SetNextSendData(iClient, "::AuthenticationFailed");
            return AUTH_FAILED;
        }

		WriteLog(pSockSrvr->icClientID[iClient], "Authentication success.");
		pSockSrvr->SetNextSendData(iClient, "::AuthenticationSuccess");
		return AUTH_SUCCESS;
	}

	return AUTH_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsValidCompanyAccount(CSockSrvr *pSockSrvr, int iClient)
{
    char sStatement[255];

	int iDataLength = 0;

	CRecordSet rsTemp;

    sprintf(sStatement, "SELECT CompDB FROM Companys WHERE CompName = '%s' AND CompPassword = '%s'", CCI[iClient].sCompanyName, CCI[iClient].sPassword);
	if(!CCI[iClient].cIndexSQL.Execute(sStatement, &rsTemp))
    {
        WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyPassword :: Execute failed.");
        return false;
    }

    if(rsTemp.RowCount < 1) //No matching company name and password
	{
		rsTemp.Close();
		return false;
	}

	if(!rsTemp.Fetch())
    {
        WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyPassword :: DBFetch failed.");
        rsTemp.Close();
        return false;
    }

	if(!rsTemp.sColumnEx(1, CCI[iClient].sCompanyDatabase, sizeof(CCI[iClient].sCompanyDatabase), &iDataLength))
    {
        WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyPassword :: DBGetData failed.");
        rsTemp.Close();
        return false;
    }

	if(iDataLength == -1)
	{
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidCompanyPassword :: DBGetData returned -1.");
		rsTemp.Close();
		return false;
	}

    rsTemp.Close();

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int IsValidClientVersion(CSockSrvr *pSockSrvr, int iClient, char *sUpdateHTTPURL)
{
    char sStatement[255];

	int iDataLength = 0;
    char ClientVersion[25 + 1];

	CRecordSet rsTemp;

	sprintf(sStatement, "SELECT Status, UpdateURL FROM ClientVersions WHERE Version = '%s'", CCI[iClient].sClientVersion);

	if(!CCI[iClient].cIndexSQL.Execute(sStatement, &rsTemp))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: Execute failed.");
        return CLIENTVER_ERROR;
    }

    if(rsTemp.RowCount == 0)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: Unknown client version.");

        rsTemp.Close();
        return CLIENTVER_ERROR;
    }

	rsTemp.Fetch();

    if(!rsTemp.sColumnEx(1, ClientVersion, 25, &iDataLength))
	{
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: DBGetData 1 failed.");

        rsTemp.Close();
        return CLIENTVER_ERROR;
    }
	if(iDataLength > 0 && iDataLength <= 25)
	{
		ClientVersion[iDataLength] = '\0';
	}

	if(!rsTemp.sColumnEx(2, sUpdateHTTPURL, 1024, &iDataLength))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: DBGetData 2 failed.");

        rsTemp.Close();
        return CLIENTVER_ERROR;
    }
	if(iDataLength > 0 && iDataLength <= 1024)
	{
		sUpdateHTTPURL[iDataLength] = '\0';
	}

    rsTemp.Close();

    if(strcmpi((char *)ClientVersion, "current") == 0){ // Current version
        return CLIENTVER_CURRENT;
    }
    else if(strcmpi((char *)ClientVersion, "supported") == 0){ // Old but supported
        return CLIENTVER_SUPPORTED;
    }
    else if(strcmpi((char *)ClientVersion, "outdated") == 0){ // Old and nolonger supported
        return CLIENTVER_OUTDATED;
    }
    else if(strcmpi((char *)ClientVersion, "autoupdate") == 0){ // Old and nolonger supported
        return CLIENTVER_AUTOUPDATE;
    }
    else{
		WriteLog(pSockSrvr->icClientID[iClient], "Error in IsValidClientVersion :: Unknown version identifier.");
        return CLIENTVER_ERROR;
    }

    return CLIENTVER_ERROR;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

